Program SmallRectangles;

Const
  MaxN=200000; //maximal amount of the rectangles
Type
  Rectangle = Record
                w, h: LongInt;
              End;
  List = Array [1..MaxN] of Rectangle;

procedure QuickSort(var A: List; Lo, Hi: LongInt);
      procedure Sort(l, r: LongInt);
      var i, j: LongInt;
          x, y: Rectangle;
      begin
        i := l; j := r; x := a[(l+r) DIV 2];
        repeat
          while (a[i].w < x.w) or
                ((a[i].w = x.w) and (a[i].h < x.h)) do Inc(i);
          while (x.w < a[j].w) or
                ((x.w = a[j].w) and (x.h < a[j].h)) do Dec(j);
          if i <= j then begin
            y := a[i]; a[i] := a[j]; a[j] := y;
            Inc(i); Dec(j);
          end;
        until i > j;
        if l < j then Sort(l, j);
        if i < r then Sort(i, r);
      end;
begin {QuickSort};
  Sort(Lo,Hi);
end;


Var f: Text;
    n: LongInt;  // rectangles amount
    r: List;  // array of the rectangles
    result: LongInt;
    maxheight: LongInt;
    i, k: LongInt;
Begin
  {Read datum}
  Assign(f, 'small.in'); Reset(f);
  Readln(f,n);
  For i:= 1 To n Do Begin
    Readln(f, r[i].w, r[i].h);
    If r[i].w<r[i].h Then Begin
      {Swap width and height}
      k:= r[i].w; r[i].w:= r[i].h; r[i].h:= k;
    End;
  End;
  Close(f);
  {Sort by width ascending, then by height ascending}
  QuickSort(r, 1, n);
  {Result evaluation}
  result:= 0;
  maxheight:= r[n].h;
  For i:= n-1 DownTo 1 Do Begin
    If r[i].h<=maxheight Then Begin
      Inc(result);
    End
    Else Begin
      maxheight:= r[i].h;
    End;
  End;
  {Output}
  Assign(f, 'small.out'); Rewrite(f);
  Writeln(f, result);
  Close(f);
End.
