Program Parallelograms;

Const MaxN=1414; //maximal amount of the points
      MaxV= MaxN*(MaxN-1) div 2;

Type TPoint = Record x,y: LongInt; End;
     TVector = TPoint;
     TList = Array [1..MaxV] of TVector;


procedure QuickSort(var a: TList; Lo, Hi: LongInt);
      procedure Sort(l, r: LongInt);
      var i, j: LongInt;
          u, v: TVector;
      begin
        i := l; j := r; u := a[(l+r) DIV 2];
        repeat
          while (a[i].x < u.x) or
                ((a[i].x = u.x) and (a[i].y < u.y)) do Inc(i);
          while (u.x < a[j].x) or
                ((u.x = a[j].x) and (u.y < a[j].y)) do Dec(j);
          if i <= j then begin
            v := a[i]; a[i] := a[j]; a[j] := v;
            Inc(i); Dec(j);
          end;
        until i > j;
        if l < j then Sort(l, j);
        if i < r then Sort(i, r);
      end;
begin {QuickSort};
  Sort(Lo,Hi);
end;

Var f: Text;
    n: LongInt;  // points amount
    p: Array [1..MaxN] of TPoint;  // array of the points
    v: TList;  // array of the vectors
    result: LongInt;
    i, j, k: LongInt;
Begin
  {Read datum}
  Assign(f, 'parall.in'); Reset(f);
  Readln(f,n);
  For i:= 1 To n Do Begin
    Readln(f, p[i].x , p[i].y);
  End;
  Close(f);

  {Stage 1. Vectors calculation}
  k:= 0; // k - vectors amount
  For i:= 1 To n-1 Do Begin
    For j:= i+1 To n Do Begin
      Inc(k);
      If p[i].x<p[j].x Then Begin
        v[k].x:= p[j].x-p[i].x;
        v[k].y:= p[j].y-p[i].y;
      End Else
      If p[i].x=p[j].x Then Begin
        v[k].x:= 0;
        v[k].y:= abs(p[j].y-p[i].y);
      End Else
      {If p[i].x>p[j].x Then} Begin
        v[k].x:= p[i].x-p[j].x;
        v[k].y:= p[i].y-p[j].y;
      End;
    End;
  End;

  {Stage 2. Vectors sorting}
  QuickSort(v, 1, k);

  {Stage 3. Result evaluation}
  j:= 1;
  For i:= 2 To k Do Begin
    If (v[i].x=v[i-1].x) and (v[i].y=v[i-1].y) Then Begin
      Inc(j);
    End
    Else Begin
      result:= result + j*(j-1) div 2;
      j:= 1;
    End;
  End;
  result:= result + j*(j-1) div 2;

  {Output}
  Assign(f, 'parall.out'); Rewrite(f);
  Writeln(f, result div 2);
  Close(f);
End.
