Program Multiple;

Const MaxN=10000; //maximal divisor
      Infinity = Succ('9');
      Ord0 = Ord('0');

Type
     TDigit = Char;
     TNumber =  String;
     TList = Array [0..MaxN-1] of TNumber;

Var f: Text;
    n: LongInt;  // divisor

    x: TList;  // purpose array
    y: TList;  // auxiliary array
    startDig: LongInt; //minimal digit proper to question sign: 1 at startDig, then 0
    digit: TDigit;
    num: TNumber;
    dig, i, k: LongInt;

Begin
  {Initialization}
  Assign(f, 'multiple.in'); Reset(f);
  Readln(f,n);
  For i:= 0 To n-1 Do Begin
    x[i]:= Infinity;
    y[i]:= Infinity;
  End;
  x[0]:= '';
  startDig:= 1;
  {Damaged number processing}
  While not SeekEoF(f) Do Begin
    { x[i] contains the minimal number such as
      1. x[i] mod n = i    and
      2. x[i] is  concerted with all read characters of the "damaged" number
    }
    Read(f, digit);   //read the next digit
    Case digit of
      '?': Begin
        For i:= 0 To n-1 Do Begin
          If (x[i]<Infinity) Then Begin
            For dig:= startDig To 9 Do Begin
              k:= (10*i+dig) mod n;
              num:= x[i]+Chr(dig+Ord0);
              If num<y[k] Then Begin
                y[k]:= num;
              End;
            End;
          End;
        End;
      End;

      '0'..'9': Begin
        dig:= Ord(digit)-Ord0;
        For i:= 0 To n-1 Do Begin
          If (x[i]<Infinity) Then Begin
            k:= (10*i+dig) mod n;
            num:= x[i]+digit;
            If num<y[k] Then Begin
              y[k]:= num;
            End;
          End;
        End;
      End;

    End; {of Case}
    { y[i] contains the minimal number being equal to i modulo n
      concerted with all read now characters
    }

    For i:= 0 To n-1 Do Begin
      x[i]:= y[i];
      y[i]:= Infinity;
    End;
    startDig:= 0;
  End;
  Close(f);

  {Output}
  Assign(f, 'multiple.out'); Rewrite(f);
  Writeln(f, x[0]);
  Close(f);
End.
