Program CardsStack;

Const MaxN = 5000; //maximal pile height
      MaxS = 50000; //maximal money
Type
     TCard = Record
               price: LongInt;
               pos: Word;
             End;
     CardsArray = Array [1..MaxN] of TCard;

procedure QuickSort(var A: CardsArray; Lo, Hi: Word);
      procedure Sort(l, r: Word);
      var i, j: LongInt;
          x, y: TCard;
      begin
        i := l; j := r; x := a[(l+r) DIV 2];
        repeat
          while (a[i].price < x.price) do Inc(i);
          while (x.price < a[j].price) do Dec(j);
          if i <= j then begin
            y := a[i]; a[i] := a[j]; a[j] := y;
            Inc(i); Dec(j);
          end;
        until i > j;
        if l < j then Sort(l, j);
        if i < r then Sort(i, r);
      end;
begin {QuickSort};
  Sort(Lo,Hi);
end;

Var N: Word;  // cards amount
    c: CardsArray;  // cards costs in natural order;
        // c[i].pos contains the position of the card in cost growing order
    a: CardsArray;  // cards costs ordered by cost growing
        // a[i].pos contains the position of the card in natural order

Function MinCost(k: Word): LongInt;
Var b: Array [1..MaxN] of Boolean;  //b[i]=True means the card #i is
                                    //still supplementable to set B
    i, CheapSearch: Word;
    sbase, s, res: LongInt;
Begin
  If k=0 Then Begin
    MinCost:= 0;
    Exit;
  End;
  For i:= 1 To N Do Begin
    b[i]:= True;
  End;
  sbase:= 0;
  For i:= 1 To k-1 Do Begin
    b[a[i].pos]:= False;
    Inc(sbase,a[i].price);
  End;
  CheapSearch:= k-1;
  res:= MaxS + 1;
  For i:= N DownTo k Do Begin
    If not b[i] Then Begin
      While not b[a[CheapSearch].pos] Do Begin
        Inc(CheapSearch);
      End;
      b[a[CheapSearch].pos]:= False;
      sbase:= sbase-c[i].price+a[CheapSearch].price;
    End;
    s:= sbase+c[i].price+(i-k);
    If s<res Then res:= s;
    b[i]:= False;
  End;
  MinCost:= res;
End;


Var f: Text;
    S: LongInt;  // talers (at start)
    left, center, right, i: Word;
    sum: LongInt;
Begin
  Assign(f, 'pile.in'); Reset(f);
  Readln(f, N, S);
  sum:= 0;
  For i:= 1 To N Do Begin
    Readln(f, c[i].price);
    Inc(sum, c[i].price);
    a[i].price:= c[i].price;
    a[i].pos:= i;
  End;
  Close(f);

  Assign(f, 'pile.out'); Rewrite(f);

  If sum<=S Then Begin
    Writeln(f, N);
    Writeln(f, sum);
  End
  Else Begin

    QuickSort(a, 1, N);
    For i:= 1 To N Do Begin
      c[a[i].pos].pos:= i;
    End;

    left:= 0;
    right:= N;
    While left+1<right Do Begin
      center:= (left+right) div 2;
      sum:= MinCost(center);
      If sum<=S Then Begin
        left:= center;
      End
      Else Begin
        right:= center;
      End;
    End;
    Writeln(f, left);
    Writeln(f, MinCost(left));
  End;
  Close(f);
End.
