Program BigLazyCat;
Uses Math;

Const MaxN=100000;
      Infinity = MaxN+1;

Type TSegment = Record
                  l, c, r: LongInt;
                  lson, rson: LongInt;
                  first, last: LongInt;
                End;
     TTree = Array [1..2*MaxN] of TSegment;
     TDirection = (Forward, Backward);
     TCat = Record
              position: LongInt;
              direction: TDirection;
            End;

Var tree: TTree;

Procedure CreateTree(N: LongInt);
Var i, w: LongInt;
Begin
  tree[1].l:= 1;  tree[1].r:= N; tree[1].c:= (N+1) div 2;
  tree[1].lson:= 0; tree[1].rson:= 0;
  tree[1].first:= MaxN+1; tree[1].last:= 0;
  i:= 1; w:= 2;
  While i<w Do Begin
    If tree[i].l<tree[i].r Then Begin
      tree[i].lson:= w;
      tree[w].l:= tree[i].l;
      tree[w].r:= tree[i].c;
      tree[w].c:= (tree[w].l+tree[w].r) div 2;
      tree[w].lson:= 0; tree[w].rson:= 0;
      tree[w].first:= Infinity; tree[w].last:= 0;
      Inc(w);
      tree[i].rson:= w;
      tree[w].l:= tree[i].c + 1;
      tree[w].r:= tree[i].r;
      tree[w].c:= (tree[w].l+tree[w].r) div 2;
      tree[w].lson:= 0; tree[w].rson:= 0;
      tree[w].first:= Infinity; tree[w].last:= 0;
      Inc(w);
    End;
    Inc(i);
  End;
End;

Procedure Switch(pos: LongInt);
  Procedure CorrectData(root: LongInt);
  Begin
    If (pos=tree[root].l) and (pos=tree[root].r) Then Begin
      If tree[root].last=0 Then Begin {Lamp On}
        tree[root].last:= pos;
        tree[root].first:= pos;
      End
      Else Begin {Lamp OFF}
        tree[root].last:= 0;
        tree[root].first:= Infinity;
      End
    End
    Else Begin
      If (pos <= tree[root].c) Then Begin
        CorrectData(tree[root].lson);
      End
      Else Begin
        CorrectData(tree[root].rson);
      End;
      tree[root].first:= min (tree[tree[root].lson].first, tree[tree[root].rson].first);
      tree[root].last:= max (tree[tree[root].lson].last, tree[tree[root].rson].last);
    End;
  End;
Begin
  CorrectData(1);
End;

Function First(from: LongInt): LongInt;
  Function GetFirst (root: LongInt): LongInt;
  {     ,  
      [from..N]  [root.l .. root.r]     }
  Begin
    If from <= tree[root].l Then Begin
      GetFirst:= tree[root].first;
    End
    Else Begin
      If (from <= tree[root].c) Then Begin
        GetFirst:= min ( GetFirst(tree[root].lson),
                         tree[tree[root].rson].first );
      End
      Else {from > tree[root].c} Begin
        GetFirst:= GetFirst(tree[root].rson);
      End;
    End;
  End;

Begin
  First:= GetFirst(1);
End;

Function Last(upto: LongInt): LongInt;
  Function GetLast (root: LongInt): LongInt;
  {     ,  
      [1..upto]  [root.l .. root.r]     }
  Begin
    If upto >= tree[root].r Then Begin
      GetLast:= tree[root].last;
    End
    Else Begin
      If (upto > tree[root].c) Then Begin
        GetLast:= max ( tree[tree[root].lson].last,
                        GetLast(tree[root].rson));
      End
      Else {upto <= tree[root].c} Begin
        GetLast:= GetLast(tree[root].lson);
      End;
    End;
  End;

Begin
  Last:= GetLast(1);
End;

Var fin, fout: Text;
    N, P: LongInt;
    cat: TCat;
Begin
  Assign(fin,'lazycat.in'); Reset(fin);
  Readln(fin, N);
  CreateTree(N);
  cat.position:= 1;
  cat.direction:= Forward;
  Switch(1);
  Assign(fout,'lazycat.out'); Rewrite(fout);
  While not EoF(fin) Do Begin
    Readln(fin, P);
    Switch(P);
    If P=cat.position Then Begin
      If cat.direction=Forward Then Begin
        P:= First(cat.position);
        If P=Infinity Then Begin
          cat.direction:= Backward;
          P:= Last(cat.position)
        End
      End
      Else Begin
        P:= Last(cat.position);
        If P=0 Then Begin
          cat.direction:= Forward;
          P:= First(cat.position)
        End
      End;
      cat.position:= P;
      Writeln(fout, cat.position);
    End;
  End;
  Close(fout);
  Close(fin);
End.
