Program JosephusProblem;

Const MaxN=150000;

Type TSegment = Record
                  l, r: LongInt;
                  lson, rson: LongInt;
                  amount: LongInt;
                End;
     TTree = Array [1..2*MaxN] of TSegment;

Var tree: TTree;

Procedure CreateTree(N: LongInt);
Var i, w: LongInt;
Begin
  tree[1].l:= 1;  tree[1].r:= N;
  tree[1].lson:= 0; tree[1].rson:= 0;
  i:= 1; w:= 2;
  While i<w Do Begin
    tree[i].amount:= tree[i].r-tree[i].l+1;
    If tree[i].l<tree[i].r Then Begin
      tree[i].lson:= w;
      tree[w].l:= tree[i].l;
      tree[w].r:= (tree[i].l+tree[i].r) div 2;
      tree[w].lson:= 0; tree[w].rson:= 0;
      Inc(w);
      tree[i].rson:= w;
      tree[w].l:= (tree[i].l+tree[i].r) div 2 + 1;
      tree[w].r:= tree[i].r;
      tree[w].lson:= 0; tree[w].rson:= 0;
      Inc(w);
    End;
    Inc(i);
  End;
End;

Function Get(K: LongInt): LongInt;
  Function GetData(root: LongInt; K: LongInt): LongInt;
  Var lamount: LongInt;
  Begin
    If tree[root].l=tree[root].r Then Begin
    {root is leaf}
      tree[root].amount:= 0;
      GetData:= tree[root].l;
    End
    Else Begin
    {root is not-leaf}
      lamount:= tree[tree[root].lson].amount;
      If K<=lamount Then Begin
        GetData:= GetData(tree[root].lson, K);
      End
      Else Begin
        GetData:= GetData(tree[root].rson, K-lamount);
      End;
      Dec(tree[root].amount);
    End;
  End;
Begin
  Get:= GetData(1, K);
End;

Var fin, fout: Text;
    N, M, order: LongInt;
Begin
  Assign(fin,'josephus.in'); Reset(fin);
  Readln(fin, N);
  CreateTree(N);
  Assign(fout,'josephus.out'); Rewrite(fout);
  order:= 1;
  While tree[1].amount>0 Do Begin
    Readln(fin, M);
    order:= (order+M-1) mod tree[1].amount;
    If order=0 Then order:= tree[1].amount;
    // variant: order:= (order+M-2) mod tree[1].amount + 1;
    Writeln(fout, Get(order));
  End;
  Close(fin);
  Close(fout);
End.
