Program Prisma;
Const NMax=100000;

Type TNode = Record
               amount: LongInt;
               l, r: LongInt;
               lson, rson: LongInt;
             End;

Var stree: Array [1..4*NMax+1] of TNode;

Procedure CreateTree(N: LongInt);
Var r, w: LongInt;
Begin
  stree[1].l:= 1;
  stree[1].r:= N;
  stree[1].amount:= 0;
  r:= 1; w:=2;
  While r<w Do Begin
    If stree[r].l<stree[r].r Then Begin
      stree[r].lson:= w;
      stree[w].l:= stree[r].l;
      stree[w].r:= (stree[r].l+stree[r].r) div 2;
      stree[w].amount:= 0;
      Inc(w);
      stree[r].rson:= w;
      stree[w].l:= (stree[r].l+stree[r].r) div 2 + 1;
      stree[w].r:= stree[r].r;
      stree[w].amount:= 0;
      Inc(w);
    End;
    Inc(r);
  End;
End;

Procedure Alter(i: LongInt; change: ShortInt);
Var w: LongInt;
Begin
  w:= 1;
  Repeat
    Inc(stree[w].amount, change);
    If i<=(stree[w].l+stree[w].r) div 2 Then Begin
      w:= stree[w].lson;
    End
    Else Begin
      w:= stree[w].rson;
    End;
  Until stree[w].l=stree[w].r;
  Inc(stree[w].amount, change);
End;

Procedure Add(i: LongInt);
Begin
  Alter(i, 1);
End;

Procedure Free(i: LongInt);
Begin
  Alter(i, -1);
End;

Function Count(a,b: LongInt): LongInt;
  Function C(v: LongInt): LongInt;
  Var m: LongInt;
  Begin
    m:= (stree[v].l+stree[v].r) div 2;
    If (a<=stree[v].l) Then Begin
      If (stree[v].r<=b) Then C:= stree[v].amount
      Else
      If (m<b) Then C:= stree[stree[v].lson].amount+C(stree[v].rson)
      Else
      {If (b<=m) Then} C:= C(stree[v].lson)
    End Else
    If (a<=m) Then Begin
      If (stree[v].r<=b) Then C:= C(stree[v].lson)+stree[stree[v].rson].amount
      Else
      If (m<b) Then C:= C(stree[v].lson)+C(stree[v].rson)
      Else
      {If (b<=m) Then} C:= C(stree[v].lson)
    End Else
    {If (a>m) Then} Begin
      C:= C(stree[v].rson)
    End;
  End;
Begin
  Count:= C(1);
End;

Var f: Text;
    N: LongInt;
    a: Array[1..2*NMax] of LongInt;
    result: Int64;
    i, c: LongInt;
Begin
  Assign(f, 'bitris.in'); Reset(f);
  Readln(f, N);
  CreateTree(2*N);
  For i:= 1 To N Do Begin
    a[i]:= 0;
  End;

  result:= 0;
  For i:= 1 To 2*N Do Begin
    Read(f, c);
    If a[c]=0 Then Begin
      a[c]:= i;
      Add(i);
    End
    Else Begin
      result:= result+Count(a[c]+1, i);
      Free(a[c]);
    End;
  End;
  Close(f);

  Assign(f, 'bitris.out'); Rewrite(f);
  Writeln(f, result);
  Close(f);
End.
